/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPTUNNEL_H
#define QKNXNETIPTUNNEL_H

#include <QtKnx/qknxaddress.h>
#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipendpointconnection.h>
#include <QtKnx/qknxlinklayerframe.h>

QT_BEGIN_NAMESPACE

class QKnxNetIpTunnelPrivate;
class Q_KNX_EXPORT QKnxNetIpTunnel final : public QKnxNetIpEndpointConnection
{
    Q_OBJECT
    Q_DISABLE_COPY(QKnxNetIpTunnel)
    Q_DECLARE_PRIVATE(QKnxNetIpTunnel)

public:
    QKnxNetIpTunnel(QObject *parent = nullptr);
    ~QKnxNetIpTunnel() override = default;

    QKnxNetIpTunnel(const QHostAddress &localAddress, QObject *parent = nullptr);
    QKnxNetIpTunnel(const QHostAddress &localAddress, quint16 localPort, QObject *parent = nullptr);
    QKnxNetIpTunnel(const QHostAddress &localAddress, quint16 localPort,
        QKnxNetIp::TunnelLayer layer, QObject *parent = nullptr);

    QKnxAddress individualAddress() const;
#if QT_DEPRECATED_SINCE(5, 13)
    QT_DEPRECATED void setIndividualAddress(const QKnxAddress &address);
#endif

    QKnxNetIp::TunnelLayer layer() const;
    void setTunnelLayer(QKnxNetIp::TunnelLayer layer);

    bool sendFrame(const QKnxLinkLayerFrame &frame);

    bool sendTunnelingFeatureGet(QKnx::InterfaceFeature feature);
    bool sendTunnelingFeatureSet(QKnx::InterfaceFeature feature, const QKnxByteArray &value);

Q_SIGNALS:
    void frameReceived(QKnxLinkLayerFrame frame);

    void tunnelingFeatureInfoReceived(QKnx::InterfaceFeature feature, QKnxByteArray value);
    void tunnelingFeatureResponseReceived(QKnx::InterfaceFeature feature, QKnx::ReturnCode code,
                                          QKnxByteArray value);
};

QT_END_NAMESPACE

#endif
